/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour;

import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.INamedIconOptions;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.outliner.ChasingAABBOutline;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class ValueBox
extends ChasingAABBOutline {
    protected class_2561 label;
    protected class_2561 sublabel = Components.immutableEmpty();
    protected class_2561 scrollTooltip = Components.immutableEmpty();
    protected class_243 labelOffset = class_243.field_1353;
    protected int passiveColor;
    protected int highlightColor;
    public boolean isPassive;
    protected class_2338 pos;
    protected ValueBoxTransform transform;
    protected class_2680 blockState;

    public ValueBox(class_2561 label, class_238 bb, class_2338 pos) {
        super(bb);
        this.label = label;
        this.pos = pos;
        this.blockState = class_310.method_1551().field_1687.method_8320(pos);
    }

    public ValueBox transform(ValueBoxTransform transform) {
        this.transform = transform;
        return this;
    }

    public ValueBox offsetLabel(class_243 offset) {
        this.labelOffset = offset;
        return this;
    }

    public ValueBox subLabel(class_2561 sublabel) {
        this.sublabel = sublabel;
        return this;
    }

    public ValueBox scrollTooltip(class_2561 scrollTip) {
        this.scrollTooltip = scrollTip;
        return this;
    }

    public ValueBox withColors(int passive, int highlight) {
        this.passiveColor = passive;
        this.highlightColor = highlight;
        return this;
    }

    public ValueBox passive(boolean passive) {
        this.isPassive = passive;
        return this;
    }

    @Override
    public void render(class_4587 ms, SuperRenderTypeBuffer buffer, float pt) {
        boolean hasTransform;
        boolean bl = hasTransform = this.transform != null;
        if (this.transform instanceof ValueBoxTransform.Sided && this.params.getHighlightedFace() != null) {
            ((ValueBoxTransform.Sided)this.transform).fromSide(this.params.getHighlightedFace());
        }
        if (hasTransform && !this.transform.shouldRender(this.blockState)) {
            return;
        }
        ms.method_22903();
        ms.method_22904((double)this.pos.method_10263(), (double)this.pos.method_10264(), (double)this.pos.method_10260());
        if (hasTransform) {
            this.transform.transform(this.blockState, ms);
        }
        this.transformNormals = ms.method_23760().method_23762().method_23296();
        this.params.colored(this.isPassive ? this.passiveColor : this.highlightColor);
        super.render(ms, buffer, pt);
        float fontScale = hasTransform ? -this.transform.getFontScale() : -0.015625f;
        ms.method_22905(fontScale, fontScale, fontScale);
        ms.method_22903();
        this.renderContents(ms, buffer);
        ms.method_22909();
        if (!this.isPassive) {
            ms.method_22903();
            ms.method_22904(17.5, -0.5, 7.0);
            ms.method_22904(this.labelOffset.field_1352, this.labelOffset.field_1351, this.labelOffset.field_1350);
            this.renderHoveringText(ms, buffer, this.label);
            if (!this.sublabel.getString().isEmpty()) {
                ms.method_22904(0.0, 10.0, 0.0);
                this.renderHoveringText(ms, buffer, this.sublabel);
            }
            if (!this.scrollTooltip.getString().isEmpty()) {
                ms.method_22904(0.0, 10.0, 0.0);
                this.renderHoveringText(ms, buffer, this.scrollTooltip, 0x998899, 0x111111);
            }
            ms.method_22909();
        }
        ms.method_22909();
    }

    public void renderContents(class_4587 ms, class_4597 buffer) {
    }

    protected void renderHoveringText(class_4587 ms, class_4597 buffer, class_2561 text) {
        this.renderHoveringText(ms, buffer, text, this.highlightColor, Color.mixColors(this.passiveColor, 0, 0.75f));
    }

    protected void renderHoveringText(class_4587 ms, class_4597 buffer, class_2561 text, int color, int shadowColor) {
        ms.method_22903();
        ValueBox.drawString(ms, buffer, text, 0.0f, 0.0f, color);
        ms.method_22904(0.0, 0.0, -0.25);
        ValueBox.drawString(ms, buffer, text, 1.0f, 1.0f, shadowColor);
        ms.method_22909();
    }

    private static void drawString(class_4587 ms, class_4597 buffer, class_2561 text, float x, float y, int color) {
        class_310.method_1551().field_1772.method_30882(text, x, y, color, false, ms.method_23760().method_23761(), buffer, false, 0, 0xF000F0);
    }

    public static class IconValueBox
    extends ValueBox {
        AllIcons icon;

        public IconValueBox(class_2561 label, INamedIconOptions iconValue, class_238 bb, class_2338 pos) {
            super(label, bb, pos);
            this.subLabel((class_2561)Lang.translateDirect(iconValue.getTranslationKey(), new Object[0]));
            this.icon = iconValue.getIcon();
        }

        @Override
        public void renderContents(class_4587 ms, class_4597 buffer) {
            super.renderContents(ms, buffer);
            float scale = 64.0f;
            ms.method_22905(scale, scale, scale);
            ms.method_22904(-0.5, -0.5, 0.03125);
            this.icon.render(ms, buffer, 0xFFFFFF);
        }
    }

    public static class TextValueBox
    extends ValueBox {
        class_2561 text;

        public TextValueBox(class_2561 label, class_238 bb, class_2338 pos, class_2561 text) {
            super(label, bb, pos);
            this.text = text;
        }

        @Override
        public void renderContents(class_4587 ms, class_4597 buffer) {
            boolean singleDigit;
            super.renderContents(ms, buffer);
            class_327 font = class_310.method_1551().field_1772;
            float scale = 4.0f;
            ms.method_22905(scale, scale, 1.0f);
            ms.method_22904(-4.0, -4.0, 5.0);
            int stringWidth = font.method_27525((class_5348)this.text);
            Objects.requireNonNull(font);
            float numberScale = 9.0f / (float)stringWidth;
            boolean bl = singleDigit = stringWidth < 10;
            if (singleDigit) {
                numberScale /= 2.0f;
            }
            Objects.requireNonNull(font);
            float verticalMargin = (float)(stringWidth - 9) / 2.0f;
            ms.method_22905(numberScale, numberScale, numberScale);
            ms.method_22904(singleDigit ? (double)(stringWidth / 2) : 0.0, singleDigit ? (double)(-verticalMargin) : (double)verticalMargin, 0.0);
            this.renderHoveringText(ms, buffer, this.text, 0xEDEDED, 0x4F4F4F);
        }
    }

    public static class ItemValueBox
    extends ValueBox {
        class_1799 stack;
        int count;

        public ItemValueBox(class_2561 label, class_238 bb, class_2338 pos, class_1799 stack, int count) {
            super(label, bb, pos);
            this.stack = stack;
            this.count = count;
        }

        @Override
        public void renderContents(class_4587 ms, class_4597 buffer) {
            super.renderContents(ms, buffer);
            class_327 font = class_310.method_1551().field_1772;
            class_5250 countString = Components.literal((String)(this.count == 0 ? "*" : "" + this.count));
            ms.method_22904(17.5, -5.0, 7.0);
            boolean isFilter = this.stack.method_7909() instanceof FilterItem;
            boolean isEmpty = this.stack.method_7960();
            float scale = 1.5f;
            ms.method_22904((double)(-font.method_27525((class_5348)countString)), 0.0, 0.0);
            if (isFilter) {
                ms.method_22904(3.0, 8.0, 7.25);
            } else if (isEmpty) {
                ms.method_22904(-17.0, -2.0, 3.0);
                scale = 2.0f;
            } else {
                ms.method_22904(-7.0, 10.0, 10.25);
            }
            ms.method_22905(scale, scale, scale);
            ValueBox.drawString(ms, buffer, (class_2561)countString, 0.0f, 0.0f, isFilter ? 0xFFFFFF : 0xEDEDED);
            ms.method_22904(0.0, 0.0, -0.0625);
            ValueBox.drawString(ms, buffer, (class_2561)countString, 0.875f, 0.875f, 0x4F4F4F);
        }
    }
}

